# Business & Real-World

## Marketing Website

### Toolbox
* [Unsplash](https://unsplash.com/) (unsplash.com)
* [Pexel](https://www.pexels.com/) (pexels.com)
* [Gatsby](https://www.gatsbyjs.org/) (gatsbyjs.org)
* [TakeShape](https://www.takeshape.io/) (takeshape.io)

### Tutorials
* [Quickly Create a New Company Website Managed by a CMS with TakeShape and Gatsby](https://egghead.io/playlists/quickly-create-a-new-company-website-managed-by-a-cms-with-takeshape-and-gatsby-4e4d?af=atzgap) (egghead.io)
* [Create your startup’s website on the Jamstack with Gatsby.js, TakeShape, and Netlify](https://www.takeshape.io/articles/create-your-startups-website-on-the-jamstack-with-gatsby-js-takeshape-and-netlify/) (takeshape.io)

## Conference Schedule

### Toolbox
* [faker.js](https://fakerjs.dev/) (fakerjs.dev)

### Tutorials
* [Create Massive Random Data Using faker.js](https://medium.com/nerd-for-tech/create-massive-random-data-using-faker-js-f47909f6fab5) (medium.com)
* [Getting Started With Faker.js: A Developer’s Guide](https://www.testim.io/blog/getting-started-with-faker-js/) (testim.io)
* [How to Generate Fake Data in Javascript Using Faker.js](https://www.youtube.com/watch?v=SeHT0ee4waU) (youtube.com)

## Ecommerce Store

### Toolbox
* [Stripe](https://stripe.com/) (stripe.com)
* [use-shopping-cart](https://useshoppingcart.com/) (useshoppingcart.com)

### Tutorials
* [Learn How to Accept Money on Jamstack Sites in 38 Minutes](https://www.netlify.com/blog/2020/04/13/learn-how-to-accept-money-on-jamstack-sites-in-38-minutes/) (netlify.com)
* [E-Commerce for React Developers [w/ Gatsby Tutorial]](https://snipcart.com/blog/react-ecommerce-gatsby-tutorial) (snipcart.com)
* [Learn to Add Apple Pay and Google Pay to React Websites](https://www.netlify.com/blog/2020/05/21/learn-to-add-apple-pay-and-google-pay-to-react-websites/) (netlify.com)
* [How to make an online store in one day using AWS, React, and Stripe](https://www.freecodecamp.org/news/how-to-make-a-store-in-one-day-aws-react-stripe/) (freecodecamp.org)
* [Creating a Static E-Commerce Website with Snipcart, GatsbyJS and DatoCMS](https://snipcart.com/blog/static-ecommerce-gatsby-datocms) (snipcart.com)
* [Learn Gatsby: How to connect a CMS and Shopping Cart to Your Gatsby Site](https://youtu.be/rlJAymE1VVw) (youtube.com)

## Website Admin

### Toolbox
* [Auth0](https://auth0.com/) (auth0.com)
* [Auth0 React SDK](https://auth0.com/docs/libraries/auth0-react) (auth0.com)

### Tutorials
* [The Complete Guide to React User Authentication with Auth0](https://auth0.com/blog/complete-guide-to-react-user-authentication/) (auth0.com)
* [Authentication in React Applications](https://kentcdodds.com/blog/authentication-in-react-applications) (kentcdodds.com)

## Metrics Dashboard

### Toolbox
* [Chart.js](https://www.chartjs.org/) (chartjs.org)
* [react-chartjs-2](https://github.com/jerairrest/react-chartjs-2) (github.com)
* [Marketstack](https://marketstack.com/) (marketstack.com)

### Tutorials
* [Creating a dashboard with React and Chart.js](https://www.createwithdata.com/react-chartjs-dashboard/) (createwithdata.com)
* [Graphing with Chart.js - Working With Data & APIs in JavaScript](https://youtu.be/5-ptp9tRApM) (youtube.com)

## Survey Creator & Manager

### Toolbox
* [Formik](https://formik.org/) (formik.org)

### Tutorials
* [React Forms](https://reactjs.org/docs/forms.html) (reactjs.org)
* [Formik Docs Tutorial](https://formik.org/docs/tutorial) (formik.org)

## Map Statistics Dashboard

### Toolbox
* [Open Disease Data API](https://disease.sh/) (disease.sh)
* [React Leaflet](https://react-leaflet.js.org/) (react-leaflet.js.org)
* [Gatsby Leaflet Starter](https://github.com/colbyfayock/gatsby-starter-leaflet) (github.com)

### Tutorials
* [How to create a Coronavirus (COVID-19) Dashboard & Map App in React with Gatsby and Leaflet](https://www.freecodecamp.org/news/how-to-create-a-coronavirus-covid-19-dashboard-map-app-in-react-with-gatsby-and-leaflet/) (freecodecamp.org)
* [How to add Coronavirus (COVID-19) case statistics to your React map dashboard with Gatsby](https://www.freecodecamp.org/news/how-to-add-coronavirus-covid-19-case-statistics-to-your-map-dashboard-in-gatsby-and-react-leaflet/) (freecodecamp.org)
* [Mapping with React Leaflet](https://egghead.io/playlists/mapping-with-react-leaflet-e0e0?af=atzgap) (egghead.io)

### Inspiration
* [COVID-19 Dashboard by the Center for Systems Science and Engineering (CSSE) at Johns Hopkins University (JHU)](https://coronavirus.jhu.edu/map.html) (coronavirus.jhu.ed)
* [Coronavirus (COVID-19) Dashboard Demo](https://coronavirus-map-dashboard.netlify.app/) (coronavirus-map-dashboard.netlify.app)

---

## Know of any other good resources?
If you know of a great tutorial or another tool that can help others, open a pull request with a link!
